# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 1999,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
package CU_cli_utils;
#"@(#)61   1.7   src/rsct/utils/cli/pm/CU_cli_utils.pm.perl, cucli, rsct_rzauh, rzauhbase 2/21/01 12:06:22"
######################################################################
#                                                                    #
# Package: CU_cli_utils.pm                                           #
#                                                                    #
# Description:                                                       #
#   This package contains utility/common subroutines for the PERL    #
#   Cluster Utilities CLI commands.                                  #
#                                                                    #
# Subroutines Available:                                             #
#                                                                    #
#   host - converts an ip address to corresponding hostname using    #
#     the system host command.                                       #
#                                                                    #
#   printCIMsg - Used to print general cucli informational messages. #
#                                                                    #
#   printCEMsg - Used to print general cucli error messages.         #
#                Uses the calling commands $main::PROGNAME.          #
#                                                                    #
# Examples:                                                          #
#   $hostname = host("129.30.40.64");                                #
#   printCEMsg("EMsgCUcliBadOperand", "bad operand");                #
#                                                                    #
#--------------------------------------------------------------------#
# Inputs:                                                            #
#   /usr/sbin/rsct/msgmaps/cucli.cucli.map - message mapping         #
#                                                                    #
# Outputs:                                                           #
#   stdout - common informational messages that get displayed.       #
#   stderr - common error messages that get displayed.               #
#                                                                    #
# External References:                                               #
#   Commands: ctdspmsg                                               #
#   AIX Commands: host                                               #
#                                                                    #
# Tab Settings:                                                      #
#   4 and tabs should be expanded to spaces before saving this file. #
#   in vi:  (:set ts=4  and   :%!expand -4)                          #
#                                                                    #
# Change Activity:                                                   #
#   990412 SAB 48413: Initial design & write.                        #
######################################################################

use Exporter ();
@ISA = qw(Exporter);
@EXPORT_OK = qw(
    host
    printCIMsg
    printCEMsg
);

use lib "/usr/sbin/rsct/pm";
use locale;

#--------------------------------------------------------------------#
# Global Variables                                                   #
#--------------------------------------------------------------------#
$MSGCAT = "cucli.cat";                 # msg catalogue for this cmd.
$MSGSET = "cucli";                     # common message set     

$CTDIR = "/usr/sbin/rsct";             # Cluster root directory
$CTBINDIR = "$CTDIR/bin";              # Cluster bin directory path
$LSMSG = "$CTBINDIR/ctdspmsg";         # list / display message rtn
$ENV{'MSGMAPPATH'} = "$CTDIR/msgmaps"; # msg maps used by $LSMSG


#--------------------------------------------------------------------#
# Exported Subroutines (with @EXPORT_OK, -> on demand).              #
#--------------------------------------------------------------------#

#--------------------------------------------------------------------#
# Common message handling (error, informational) routines:           #
#--------------------------------------------------------------------#

#--------------------------------------------------------------------#
# host : converts the specified ip address to its corresponding      #
#   hostname using the AIX host command.                             #
#   If the hostname cannot be determined the value returned is NULL. #
#                                                                    #
# Paramaters:                                                        #
#   ip_address  in  IP Address, example "129.30.50.65".              #
#                                                                    #
# Returns:                                                           #
#   hostname        NULL if host command cannot resolve.             #
#                                                                    #
# Global Variables:                                                  #
#   $main::Trace    in  Trace mode.                                  #
#--------------------------------------------------------------------#
sub host
{
my $ip_address = shift;
my ($hostname, $temp);

($main::Trace) && print "host $ip_address is: ";

$hostname = `host $ip_address 2> /dev/null`;
if ($? == 0) {
    ($hostname, $temp) = split(/\s+/,$hostname);
}
else {
    $hostname = "";
}

($main::Trace) && print "$hostname\n";

return $hostname;
}   #end host


#--------------------------------------------------------------------#
# printCIMsg : Calls $LSMSG $to print out the common cluster         #
#   utilities cli information messages with the required paramaters. #
#   Messages printed to stdout.                                      #
#   This subroutine is like printIMsg except it is used to print     #
#   the common CU CLI messages which are in the cucli message set.   #
#                                                                    #
# Paramaters:                                                        #
#   msg       in  Message mnemonic / message number in a sense.      #
#   optargs   in  Extra arguments/parameters to send to $LSMSG.      #
#                                                                    #
# Returns:  None.                                                    #
#                                                                    #
# Global Variables:                                                  #
#   $main::Trace    in  Prints extra info when trace is on.          #
#   $LSMSG          in  Path & Command to display messages.          #
#   $MSGCAT         in  CU CLI Message catalogue.                    #
#   $MSGSET         in  CU CLI common message set "cucli".           #
#--------------------------------------------------------------------#
sub printCIMsg
{
my ($msg, @optargs) = @_;
my ($optarg, $optargs);

$main::Trace &&
    print STDERR "$LSMSG $MSGSET $MSGCAT $msg @optargs\n";

# Keep the args to LSMSG separate by separating with single quotes
# but must replace internal single quotes with blanks or get an error.
# Must escape internal double quotes for the system call.
foreach $optarg (@optargs) {
    $optarg =~ s/'/ /g;
    $optarg =~ s/"/\\"/g;
}
$optargs = "'" . join("' '", @optargs) . "'";

(scalar @optargs > 0) ?
    system "$LSMSG $MSGSET $MSGCAT $msg $optargs" :
    system "$LSMSG $MSGSET $MSGCAT $msg";

return;
}   # end printCIMsg


#--------------------------------------------------------------------#
# printCEMsg : Calls $LSMSG to print out the common cluster          #
#   utilities cli error messages with the required paramaters.       #
#   Messages printed to stderr.                                      #
#   This subroutine is like printEMsg except it is used to print     #
#   the common CU CLI messages which are in the cucli message set    #
#   and it prefixes the message with the appropriate program name.   #
#                                                                    #
# Paramaters:                                                        #
#   msg       in  Message mnemonic / message number in a sense.      #
#   optargs   in  Extra arguments/parameters to send to $LSMSG.      #
#                                                                    #
# Returns:  None.                                                    #
#                                                                    #
# Global Variables:                                                  #
#   $main::Trace    in  Prints extra info when trace is on.          #
#   $main::PROGNAME in  Calling program/command for error message.   #
#   $LSMSG          in  Path and command to display messages.        #
#   $MSGCAT         in  CU CLI Message catalogue.                    #
#   $MSGSET         in  CU CLI common message set "cucli".           #
#--------------------------------------------------------------------#
sub printCEMsg
{
my ($msg, @optargs) = @_;
my ($optarg, $optargs);

$main::Trace &&
    print STDERR "$LSMSG $MSGSET $MSGCAT $msg $main::PROGNAME @optargs\n";

# Keep the args to LSMSG separate by separating with single quotes
# but must replace internal single quotes with blanks or get an error.
# Must escape internal double quotes for the system call.
foreach $optarg (@optargs) {
    $optarg =~ s/'/ /g;
    $optarg =~ s/"/\\"/g;
}
$optargs = "'" . join("' '", @optargs) . "'";

(scalar @optargs > 0) ?
    system "$LSMSG $MSGSET $MSGCAT $msg $main::PROGNAME $optargs 1>&2" :
    system "$LSMSG $MSGSET $MSGCAT $msg $main::PROGNAME 1>&2";

return;
}   # end printCEMsg


#--------------------------------------------------------------------#
# End Exported Subroutines (with @EXPORT_OK, -> on demand).          #
#--------------------------------------------------------------------#

#--------------------------------------------------------------------#
# End File.                                                          #
#--------------------------------------------------------------------#
